--http://mini.pld.ttu.ee/~lrv/gcd/gcd-test.vhdl
------------------------------------------------------------------------
-- Testbench for yet another GCD implementation targeting different
-- synthesizable codes
------------------------------------------------------------------------
-- L(R)V 2011
------------------------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;

entity test is
end entity test;

architecture bench of test is
  signal clk, rst, rdy: bit := '1';
  signal a, b : unsigned(0 to 7);
  signal c : unsigned(0 to 15);

  component multiplier
    port (clk, rst : in bit;
           rdy: out bit;
	  a, b: in unsigned(0 to 7);
             c: out unsigned(0 to 15) );
  end component;
begin
      clk <= not clk after 10 ns;

      F: multiplier port map (clk, rst, rdy, a, b, c);
    process
      type int_array is array (0 to 2) of integer;
      constant x: int_array := (27, 33, 15);--245, 121, 52, 333, 125, 422);
      constant y: int_array := (18, 10, 8); --45, 11, 452, 121, 625, 312);
      -- expected results 9,  1,  5,  11,  4,   1,  125,   2  
    begin
      --a <= conv_unsigned(10, 8);
      --b <= conv_unsigned(4, 8);
      wait on clk until clk= '0';
      for  i in x'range  loop
        a <= conv_unsigned(x(i), 8);
        b <= conv_unsigned(y(i), 8);
	rst <= '0';
        wait on clk until clk='0';
        rst <= '1';
        while  rdy = '0'  loop
          wait on clk until clk='0';
      	end loop;
        wait on clk until clk='0';
    end loop;
    wait on clk until clk='0';
    wait;
  end process;
end bench;